function AISMN_MoveAwayFromThreat::OnEnter(%this,%obj)
{
   %threat = %obj.getSeenEnemy();
   if(0 == %threat)
   {
      SetStateVariable(%obj,0,1.0); //No threat exists
      return;
   }
   
   if(!SetPathAwayFromObject(%obj,%threat))
   {
      SetPathForNearbySpot(%obj, $AI_PATHQUERYCOUNT);
   }
   
   GetThisObject(%obj).playThread( 0, "run");
   
   return;
}

function AISMN_MoveAwayFromThreat::OnExit(%this,%obj)
{
   GetThisObject(%obj).playThread( 0, "root");
   return;
}

//EXIT 0: NO THREAT EXISTS NEAR OBJECT / DONE RUNNING
function AISMN_MoveAwayFromThreat::Update(%this,%obj)
{
   if(!IsFollowingPath(%obj) || GetStateVariable(%obj,0) > 0)
   {
      %threat = %obj.getSeenEnemy();
      if(0 == %threat)
      {
         ReturnValue(%obj,0); //No threat exists
         return;
      }
      SetPathAwayFromObject(%obj,%threat);
      return;
   }
   ReturnValue(%obj,-1);
   return;
}